#include "SpriteBatcher.h"
#include "TextureSection.h"



SpriteBatcher::SpriteBatcher() :
  m_pTexture( NULL ),
  m_UsedBatchSize( 0 )
{
}



void SpriteBatcher::Render( LPDIRECT3DDEVICE9 pDevice )
{

  if ( m_UsedBatchSize )
  {
    pDevice->SetFVF( D3DFVF_DIFFUSE | D3DFVF_XYZRHW | D3DFVF_TEX1 );
    pDevice->SetTexture( 0, m_pTexture );
    /*
    pDevice->SetRenderState( D3DRS_ZENABLE, TRUE );
    pDevice->SetRenderState( D3DRS_ZWRITEENABLE, TRUE );
    */
    pDevice->DrawPrimitiveUP( D3DPT_TRIANGLELIST, m_UsedBatchSize / 3, &m_Batch[0], sizeof( BatchVertex ) );

    //dh::Log( "Rendered with %d quads", m_UsedBatchSize / 6 );
    m_UsedBatchSize = 0;
  }

}



void SpriteBatcher::AddBatch( LPDIRECT3DDEVICE9 pDevice, int X, int Y, float Z, const TextureSection& TexSec, DWORD Color1, DWORD Color2, DWORD Color3, DWORD Color4 )
{

  if ( TexSec.pTexture != m_pTexture )
  {
    if ( m_UsedBatchSize )
    {
      Render( pDevice );
    }
    m_pTexture = TexSec.pTexture;

    if ( m_pTexture )
    {
      D3DSURFACE_DESC   ddsd;

      if ( SUCCEEDED( m_pTexture->GetLevelDesc( 0, &ddsd ) ) )
      {
        m_TextureTrueWidth  = ddsd.Width;
        m_TextureTrueHeight = ddsd.Height;
      }
    }
  }

  if ( m_UsedBatchSize + 6 >= m_Batch.size() )
  {
    // reserve no space
    if ( m_Batch.empty() )
    {
      m_Batch.resize( 600 );
    }
    else
    {
      m_Batch.resize( m_Batch.size() * 2 );
    }
  }

  BatchVertex&    Vertex1( m_Batch[m_UsedBatchSize] );
  BatchVertex&    Vertex2( m_Batch[m_UsedBatchSize + 1] );
  BatchVertex&    Vertex3( m_Batch[m_UsedBatchSize + 2] );
  BatchVertex&    Vertex4( m_Batch[m_UsedBatchSize + 3] );
  BatchVertex&    Vertex5( m_Batch[m_UsedBatchSize + 4] );
  BatchVertex&    Vertex6( m_Batch[m_UsedBatchSize + 5] );

  Vertex6.Z = Vertex5.Z = Vertex4.Z = Vertex3.Z = Vertex2.Z = Vertex1.Z = Z;
  Vertex6.RHW = Vertex5.RHW = Vertex4.RHW = Vertex3.RHW = Vertex2.RHW = Vertex1.RHW = 1.0f;

  static float Delta = -0.5f;

  Vertex1.X = X + Delta;
  Vertex1.Y = Y + Delta;
  Vertex1.Color = Color1;
  Vertex1.TU = (float)TexSec.rect.left / m_TextureTrueWidth;
  Vertex1.TV = (float)TexSec.rect.top / m_TextureTrueHeight;

  Vertex2.X = X + TexSec.rect.right - TexSec.rect.left + Delta;
  Vertex2.Y = Y + Delta;
  Vertex2.Color = Color2;
  Vertex2.TU = (float)( TexSec.rect.right - 0 ) / m_TextureTrueWidth;
  Vertex2.TV = (float)TexSec.rect.top / m_TextureTrueHeight;

  Vertex3.X = X + Delta;
  Vertex3.Y = Y + TexSec.rect.bottom - TexSec.rect.top + Delta;
  Vertex3.Color = Color3;
  Vertex3.TU = (float)TexSec.rect.left / m_TextureTrueWidth;
  Vertex3.TV = (float)( TexSec.rect.bottom - 0 ) / m_TextureTrueHeight;

  Vertex4.X = X + Delta;
  Vertex4.Y = Y + TexSec.rect.bottom - TexSec.rect.top + Delta;
  Vertex4.Color = Color3;
  Vertex4.TU = (float)TexSec.rect.left / m_TextureTrueWidth;
  Vertex4.TV = (float)( TexSec.rect.bottom - 0 ) / m_TextureTrueHeight;

  Vertex5.X = X + TexSec.rect.right - TexSec.rect.left + Delta;
  Vertex5.Y = Y + Delta;
  Vertex5.Color = Color2;
  Vertex5.TU = (float)( TexSec.rect.right - 0 ) / m_TextureTrueWidth;
  Vertex5.TV = (float)TexSec.rect.top / m_TextureTrueHeight;

  Vertex6.X = X + TexSec.rect.right - TexSec.rect.left + Delta;
  Vertex6.Y = Y + TexSec.rect.bottom - TexSec.rect.top + Delta;
  Vertex6.Color = Color4;
  Vertex6.TU = (float)( TexSec.rect.right - 0 ) / m_TextureTrueWidth;
  Vertex6.TV = (float)( TexSec.rect.bottom - 0 ) / m_TextureTrueHeight;

  m_UsedBatchSize += 6;

}



void SpriteBatcher::AddBatch( LPDIRECT3DDEVICE9 pDevice, int X1, int Y1, int X2, int Y2, int X3, int Y3, int X4, int Y4, float Z, const TextureSection& TexSec, DWORD Color1, DWORD Color2, DWORD Color3, DWORD Color4 )
{

  if ( TexSec.pTexture != m_pTexture )
  {
    if ( m_UsedBatchSize )
    {
      Render( pDevice );
    }
    m_pTexture = TexSec.pTexture;

    if ( m_pTexture )
    {
      D3DSURFACE_DESC   ddsd;

      if ( SUCCEEDED( m_pTexture->GetLevelDesc( 0, &ddsd ) ) )
      {
        m_TextureTrueWidth  = ddsd.Width;
        m_TextureTrueHeight = ddsd.Height;
      }
    }
  }

  if ( m_UsedBatchSize + 6 >= m_Batch.size() )
  {
    // reserve no space
    if ( m_Batch.empty() )
    {
      m_Batch.resize( 600 );
    }
    else
    {
      m_Batch.resize( m_Batch.size() * 2 );
    }
  }

  BatchVertex&    Vertex1( m_Batch[m_UsedBatchSize] );
  BatchVertex&    Vertex2( m_Batch[m_UsedBatchSize + 1] );
  BatchVertex&    Vertex3( m_Batch[m_UsedBatchSize + 2] );
  BatchVertex&    Vertex4( m_Batch[m_UsedBatchSize + 3] );
  BatchVertex&    Vertex5( m_Batch[m_UsedBatchSize + 4] );
  BatchVertex&    Vertex6( m_Batch[m_UsedBatchSize + 5] );

  Vertex6.Z = Vertex5.Z = Vertex4.Z = Vertex3.Z = Vertex2.Z = Vertex1.Z = Z;
  Vertex6.RHW = Vertex5.RHW = Vertex4.RHW = Vertex3.RHW = Vertex2.RHW = Vertex1.RHW = 1.0f;

  static float Delta = -0.5f;

  Vertex1.X = X1 + Delta;
  Vertex1.Y = Y1 + Delta;
  Vertex1.Color = Color1;
  Vertex1.TU = (float)TexSec.rect.left / m_TextureTrueWidth;
  Vertex1.TV = (float)TexSec.rect.top / m_TextureTrueHeight;

  Vertex2.X = X2 + Delta;
  Vertex2.Y = Y2 + Delta;
  Vertex2.Color = Color2;
  Vertex2.TU = (float)( TexSec.rect.right - 0 ) / m_TextureTrueWidth;
  Vertex2.TV = (float)TexSec.rect.top / m_TextureTrueHeight;

  Vertex3.X = X3 + Delta;
  Vertex3.Y = Y3 + Delta;
  Vertex3.Color = Color3;
  Vertex3.TU = (float)TexSec.rect.left / m_TextureTrueWidth;
  Vertex3.TV = (float)( TexSec.rect.bottom - 0 ) / m_TextureTrueHeight;

  Vertex4.X = X3 + Delta;
  Vertex4.Y = Y3 + Delta;
  Vertex4.Color = Color3;
  Vertex4.TU = (float)TexSec.rect.left / m_TextureTrueWidth;
  Vertex4.TV = (float)( TexSec.rect.bottom - 0 ) / m_TextureTrueHeight;

  Vertex5.X = X2 + Delta;
  Vertex5.Y = Y2 + Delta;
  Vertex5.Color = Color2;
  Vertex5.TU = (float)( TexSec.rect.right - 0 ) / m_TextureTrueWidth;
  Vertex5.TV = (float)TexSec.rect.top / m_TextureTrueHeight;

  Vertex6.X = X4 + Delta;
  Vertex6.Y = Y4 + Delta;
  Vertex6.Color = Color4;
  Vertex6.TU = (float)( TexSec.rect.right - 0 ) / m_TextureTrueWidth;
  Vertex6.TV = (float)( TexSec.rect.bottom - 0 ) / m_TextureTrueHeight;

  m_UsedBatchSize += 6;

}
